#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodUnitModification : BaseTest 
	{

		
		private DataTable _dtModification;
		private DataTable _dtModificationEquipment;
		private DataTable _dtModificationSupply;
		private DateTime _currentDateTime;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//this.CreateSuppliesAndEquipment();	//HACK For now -- INDY

				//GetModificationEquipment() data***************************************************
				this._dtModificationEquipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * from ModificationEquipment WHERE BloodUnitModificationGuid IN (SELECT BloodUnitModificationGuid FROM BloodUnitModification WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND RecordStatusCode = 'A')", true);

				//GetModificationSupply() data******************************************************
				this._dtModificationSupply = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * from ModificationSupply WHERE BloodUnitModificationGuid IN (SELECT BloodUnitModificationGuid FROM BloodUnitModification WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'  AND RecordStatusCode = 'A')", true);

				//GetModifiedBloodUnitChildren() data******************************************************
				this._dtModification = UnitTestUtil.RunSQLGetDataTable("SELECT * from BloodUnitModification WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND RecordStatusCode = 'A'", true);

				this.RefreshData = false;
			}

			this._currentDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		/// Flurking Shnit! COPIED FROM BOL - HACK for now - INDY
		/// </summary>
		private void CreateSuppliesAndEquipment()
		{
			System.Collections.ArrayList tstSupplies = new System.Collections.ArrayList();
			System.Collections.ArrayList tstEquipment = new System.Collections.ArrayList();

			BOL.Supply container = null;
			BOL.Supply supply = null;
			BOL.Supply supply2 = null;
			BOL.Supply scdWafer = null;
			BOL.Equipment equipment = null;
			BOL.Equipment equipment2 = null;
			

			//Create a NEW CONTAINER!!!
			container = new BOL.Supply(System.Guid.NewGuid());
			container.LotQuantity = 500;
			container.AvailableQuantity = 100;
			container.DivisionCode = this.TestDivisionCode;
			container.InvoiceNumber = new Random().Next(11111,999999).ToString();
			container.LotExpirationDate = System.DateTime.Now.AddYears(1);
			container.LotNumber = new Random().Next(11111,99999).ToString();
			container.ManufacturerName = "Wendy's Discount Blood Supplies and Burgers";
			container.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			container.ReceiptTechId = Common.LogonUser.LogonUserName;
			container.SatisfactoryIndicator = true;
			container.SupplyName = "Sterile Shoe";
			container.SupplyTypeId = (int)Common.SupplyType.Containers;
			tstSupplies.Add(container);

			//Create a NEW SUPPLY 
			supply = new BOL.Supply(System.Guid.NewGuid());
			supply.LotQuantity = 500;
			supply.AvailableQuantity = 100;
			supply.DivisionCode = this.TestDivisionCode;
			supply.InvoiceNumber = new Random().Next(11111,999999).ToString();
			supply.LotExpirationDate = System.DateTime.Now.AddYears(1);
			supply.LotNumber = new Random().Next(11111,99999).ToString();
			supply.ManufacturerName = "Wendy's Discount Blood Supplies and Burgers";
			supply.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			supply.ReceiptTechId = Common.LogonUser.LogonUserName;
			supply.SatisfactoryIndicator = true;
			supply.SupplyName = "Rawhide Proctological Gloves";
			supply.SupplyTypeId = (int)Common.SupplyType.Gloves;
			tstSupplies.Add(supply);

			//Create a 2nd supply
			supply2 = new BOL.Supply(System.Guid.NewGuid());
			supply2.LotQuantity = 500;
			supply2.AvailableQuantity = 100;
			supply2.DivisionCode = this.TestDivisionCode;
			supply2.InvoiceNumber = new Random().Next(11111,999999).ToString();
			supply2.LotExpirationDate = System.DateTime.Now.AddYears(1);
			supply2.LotNumber = new Random().Next(11111,99999).ToString();
			supply2.ManufacturerName = "Grimey's Supply House";
			supply2.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			supply2.ReceiptTechId = Common.LogonUser.LogonUserName;
			supply2.SatisfactoryIndicator = true;
			supply2.SupplyName = "Lubricated Cotton Swabs";
			supply2.SupplyTypeId = (int)Common.SupplyType.OtherEach;
			tstSupplies.Add(supply2);

			//Create a NEW SCDWAFER 
			scdWafer = new BOL.Supply(System.Guid.NewGuid());
			scdWafer.LotQuantity = 500;
			scdWafer.AvailableQuantity = 100;
			scdWafer.DivisionCode = this.TestDivisionCode;
			scdWafer.InvoiceNumber = new Random().Next(11111,999999).ToString();
			scdWafer.LotExpirationDate = System.DateTime.Now.AddYears(1);
			scdWafer.LotNumber = new Random().Next(11111,99999).ToString();
			scdWafer.ManufacturerName = "Wendy's Discount Blood Supplies and Burgers";
			scdWafer.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			scdWafer.ReceiptTechId = Common.LogonUser.LogonUserName;
			scdWafer.SatisfactoryIndicator = true;
			scdWafer.SupplyName = "Mmmmmmm Wafer";
			scdWafer.SupplyTypeId = (int)Common.SupplyType.SCDWafer;
			tstSupplies.Add(scdWafer);

			if (!BOL.Supply.InsertSupplies(tstSupplies, Common.UpdateFunction.UnitTests))
				Assert.IsTrue(false, "Supplies creation failed.. Supply Insert bombed! -- CreateSuppliesAndEquipment()");

			//Create a NEW EQUIPMENT!!
			equipment = new BOL.Equipment(System.Guid.NewGuid());
			equipment.DivisionCode = this.TestDivisionCode;
			equipment.EquipmentName = "Ostrich Egg";
			equipment.EquipmentType = "Snack";
			equipment.InspectionIndicator = true;
			equipment.InvoiceNumber = new Random().Next(11111,99999).ToString();
			equipment.IsMaintenanceContractDate = false;
			equipment.LocalIdentifier = "Meh-" + new Random().Next(111,999).ToString();
			equipment.ManufacturerName = "HJS Enterprizes";
			equipment.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			equipment.ReceiptTechId = Common.LogonUser.LogonUserName;
			equipment.SerialNumber = new Random().Next(111111,999999).ToString();
			tstEquipment.Add(equipment);
			
			//Create a 2nd Equipment
			equipment2 = new BOL.Equipment(System.Guid.NewGuid());
			equipment2.DivisionCode = this.TestDivisionCode;
			equipment2.EquipmentName = "Rosewood Stabbing Stick";
			equipment2.EquipmentType = "Tool";
			equipment2.InspectionIndicator = true;
			equipment2.InvoiceNumber = new Random().Next(11111,99999).ToString();
			equipment2.IsMaintenanceContractDate = false;
			equipment2.LocalIdentifier = "Doh-" + new Random().Next(111,999).ToString();
			equipment2.ManufacturerName = "Indy Inc";
			equipment2.ReceiptDate = System.DateTime.Now.AddMinutes(-30);
			equipment2.ReceiptTechId = Common.LogonUser.LogonUserName;
			equipment2.SerialNumber = new Random().Next(111111,999999).ToString();
			tstEquipment.Add(equipment2);

			if (!BOL.Equipment.InsertEquipment(tstEquipment, Common.UpdateFunction.UnitTests))
				Assert.IsTrue(false, "Equipment creation failed.. Equipment Insert bombed! -- CreateSuppliesAndEquipment()");

		}


		[Test]
		public void GetModifiableBloodUnits_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open,false);

			//Split is allowed for all units, so this WILL be > 0
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(45, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh); 
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode); 
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			
		}

		[Test]
		public void GetModifiableBloodUnits_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Unknown, Common.ModifyUnitMethod.Open,false);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPoolCounter_Pass()
		{
			string strYear = System.DateTime.Now.ToString("yy");

			DataTable dtCurrentData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PoolCounter WHERE CounterYear = '" + strYear + "' AND DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'");
            DataTable dtDeadData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PoolCounter WHERE CounterYear = '" + strYear + "' AND DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'X' ORDER BY CounterValue DESC");

			DataTable dtTest = DAL.BloodUnitModification.GetPoolCounter(strYear);

			//GetPoolCounter returns the top A and maximum X record (if exists)
		    Assert.AreEqual(dtTest.Rows.Count, dtCurrentData.Rows.Count + dtDeadData.Rows.Count, "Rows.Count");

			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");  //CR3320- removed 3 columns, added 1 new
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PoolCounter.PoolCounterGuid), TABLES.PoolCounter.PoolCounterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PoolCounter.CounterValue), TABLES.PoolCounter.CounterValue);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PoolCounter.RecordStatusCode), TABLES.PoolCounter.RecordStatusCode);

            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.VbecsLockId), TABLES.VbecsLock.VbecsLockId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PoolCounter.LastUpdateFunctionId), TABLES.PoolCounter.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PoolCounter.RowVersion), TABLES.PoolCounter.RowVersion);
		}

		[Test]
		public void GetPoolCounter_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetPoolCounter("XX");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void InsertPoolCounter_Pass()
		{
			string strYear = System.DateTime.Now.ToString("yy");

			DataTable dtCurrent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PoolCounter WHERE DivisionCode = '" + this.TestDivisionCode + "' AND CounterYear = '" + strYear + "' ORDER BY LastUpdateDate DESC");
			int counterYear = (int)dtCurrent.Rows[0][TABLES.PoolCounter.CounterValue];
			System.Guid poolCounterGuid = System.Guid.NewGuid();

			DataRow drReturn = DAL.BloodUnitModification.InsertPoolCounter(poolCounterGuid, ++counterYear, strYear);

			Assert.NotNull(drReturn, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(System.Data.SqlClient.SqlException))]
		public void InsertPoolCounter_Fail()
		{
            //used to raise UniqueDatabaseConstraintViolatedException, what changed?
			string strYear = System.DateTime.Now.ToString("yy");

			DataTable dtCurrent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PoolCounter WHERE DivisionCode = '" + this.TestDivisionCode + "' AND CounterYear = '" + strYear + "' ORDER BY LastUpdateDate DESC");
			int counterYear = (int)dtCurrent.Rows[0][TABLES.PoolCounter.CounterValue];
			System.Guid poolCounterGuid = (System.Guid)dtCurrent.Rows[0][TABLES.PoolCounter.PoolCounterGuid];

			DAL.BloodUnitModification.InsertPoolCounter(poolCounterGuid, ++counterYear, strYear);
		}

		[Test]
		public void InactivatePoolCounter_Pass()
		{
			DataRow drCurrent = CheckAndInsertPoolCounterIfNeeded();
			//
			bool retValue = DAL.BloodUnitModification.InactivatePoolCounter(drCurrent);
			//
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void InactivatePoolCounter_Fail()
		{
			DataRow drCurrent = CheckAndInsertPoolCounterIfNeeded();
			//
			drCurrent[TABLES.PoolCounter.RowVersion] = new byte[8];
			//
			DAL.BloodUnitModification.InactivatePoolCounter(drCurrent);
		}

		[Test]
		public void GetModificationEquipment_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtModificationEquipment.Rows[0][TABLES.ModificationEquipment.BloodUnitModificationGuid];

			DataTable dtTest = DAL.BloodUnitModification.GetModificationEquipment(unitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.ModificationEquipmentGuid), TABLES.ModificationEquipment.ModificationEquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.BloodUnitModificationGuid), TABLES.ModificationEquipment.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.EquipmentGuid), TABLES.ModificationEquipment.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.RowVersion), TABLES.ModificationEquipment.RowVersion);
		}

		[Test]
		public void GetModificationEquipment_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetModificationEquipment(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetModificationSupplies_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtModificationSupply.Rows[0][TABLES.ModificationSupply.BloodUnitModificationGuid];

			DataTable dtTest = DAL.BloodUnitModification.GetModificationSupplies(unitGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.ModificationSupplyGuid), TABLES.ModificationSupply.ModificationSupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.BloodUnitModificationGuid), TABLES.ModificationSupply.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.SupplyGuid), TABLES.ModificationSupply.SupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.RowVersion), TABLES.ModificationSupply.RowVersion);
		}

		[Test]
		public void GetModificationSupplies_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetModificationSupplies(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetPooledBloodUnits_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetPooledBloodUnits();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(44, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
	
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh); 
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode); 
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPooledBloodUnits_Fail()
		{
		}

		[Test]
		public void GetBloodUnitsInPool_Pass()
		{
			DataTable dtPools = DAL.BloodUnitModification.GetPooledBloodUnits();

			System.Guid unitGuid = (System.Guid)dtPools.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			int poolCount = System.Convert.ToInt32(dtPools.Rows[0][ARTIFICIAL.PooledUnitsCount]);

			DataTable dtTest = DAL.BloodUnitModification.GetBloodUnitsInPool(unitGuid);

//			Assertion.AreEqual("Rows.Count", poolCount, dtTest.Rows.Count);
			Assert.AreEqual(13, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.BloodUnitModificationGuid), TABLES.BloodUnitModification.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromBloodUnitGuid), TABLES.BloodUnitModification.FromBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ToBloodUnitGuid), TABLES.BloodUnitModification.ToBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ProductModificationCode), TABLES.BloodUnitModification.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationDate), TABLES.BloodUnitModification.ModificationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationTechId), TABLES.BloodUnitModification.ModificationTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationMethodCode), TABLES.BloodUnitModification.ModificationMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewContainerWeldIndicator), TABLES.BloodUnitModification.NewContainerWeldIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewLabelVerificationDatetime), TABLES.BloodUnitModification.NewLabelVerificationDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.DivisionCode), TABLES.BloodUnitModification.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.OriginalUnitIndicator), TABLES.BloodUnitModification.OriginalUnitIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.RowVersion), TABLES.BloodUnitModification.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationCost), TABLES.BloodUnitModification.ModificationCost);
		}

		[Test]
		public void GetBloodUnitsInPool_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetBloodUnitsInPool(System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		
		[Test]
		public void GetEmptyBloodUnitTestTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyBloodUnitTestTable();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.EntryTechId), TABLES.BloodUnitTest.EntryTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateUser), TABLES.BloodUnitTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateFunctionId), TABLES.BloodUnitTest.LastUpdateFunctionId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyBloodUnitTestTable_Fail()
		{
		}

		[Test]
		public void GetEmptyShipmentTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyShipmentTable();

			Assert.AreEqual(TABLES.Shipment.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentGuid), TABLES.Shipment.ShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LocalSupplierGuid), TABLES.Shipment.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ProductShipperGuid), TABLES.Shipment.ProductShipperGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDirection), TABLES.Shipment.ShipmentDirection);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.InvoiceNumber), TABLES.Shipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.DivisionCode), TABLES.Shipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateUser), TABLES.Shipment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateFunctionId), TABLES.Shipment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.RecordStatusCode), TABLES.Shipment.RecordStatusCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyShipmentTable_Fail()
		{
		}

		[Test]
		public void GetEmptyBloodUnitShipmentTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyBloodUnitShipmentTable();

			Assert.AreEqual(TABLES.BloodUnitShipment.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.BloodUnitShipmentGuid), TABLES.BloodUnitShipment.BloodUnitShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.BloodUnitGuid), TABLES.BloodUnitShipment.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.LastUpdateUser), TABLES.BloodUnitShipment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.RecordStatusCode), TABLES.BloodUnitShipment.RecordStatusCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyBloodUnitShipmentTable_Fail()
		{
		}

		
		[Test]
		public void GetEmptyOrderedUnitTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyOrderedUnitTable();

			Assert.AreEqual(TABLES.OrderedUnit.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(13, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), TABLES.OrderedUnit.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedComponentGuid), TABLES.OrderedUnit.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.OrderedTestGuid), TABLES.OrderedUnit.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.BloodUnitGuid), TABLES.OrderedUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedDate), TABLES.OrderedUnit.SelectedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.SelectedTechId), TABLES.OrderedUnit.SelectedTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchRequiredIndicator), TABLES.OrderedUnit.CrossmatchRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchDate), TABLES.OrderedUnit.CrossmatchDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode), TABLES.OrderedUnit.CrossmatchResultCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.CrossmatchTechId), TABLES.OrderedUnit.CrossmatchTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.DivisionCode), TABLES.OrderedUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.RecordStatusCode), TABLES.OrderedUnit.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedUnit.LastUpdateUser), TABLES.OrderedUnit.LastUpdateUser);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyOrderedUnitTable_Fail()
		{
		}

		[Test]
		public void GetEmptyBloodUnitModificationTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyBloodUnitModificationTable(true);

			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.BloodUnitModificationGuid), TABLES.BloodUnitModification.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationDate), TABLES.BloodUnitModification.ModificationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationTechId), TABLES.BloodUnitModification.ModificationTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewLabelVerificationDatetime), TABLES.BloodUnitModification.NewLabelVerificationDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.DivisionCode), TABLES.BloodUnitModification.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.PoolEditedIndicator), TABLES.BloodUnitModification.PoolEditedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.Comments), TABLES.BloodUnitModification.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.OriginalUnitIndicator), TABLES.BloodUnitModification.OriginalUnitIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.RecordStatusCode), TABLES.BloodUnitModification.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.RowVersion), TABLES.BloodUnitModification.RowVersion);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationCost), TABLES.BloodUnitModification.ModificationCost);
		}

		[Test]
		public void GetEmptyBloodUnitModificationTable_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyBloodUnitModificationTable(false);

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.BloodUnitModificationGuid), TABLES.BloodUnitModification.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationDate), TABLES.BloodUnitModification.ModificationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationTechId), TABLES.BloodUnitModification.ModificationTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewLabelVerificationDatetime), TABLES.BloodUnitModification.NewLabelVerificationDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.DivisionCode), TABLES.BloodUnitModification.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.PoolEditedIndicator), TABLES.BloodUnitModification.PoolEditedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.Comments), TABLES.BloodUnitModification.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.OriginalUnitIndicator), TABLES.BloodUnitModification.OriginalUnitIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromBloodUnitGuid), TABLES.BloodUnitModification.FromBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationMethodCode), TABLES.BloodUnitModification.ModificationMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewContainerWeldIndicator), TABLES.BloodUnitModification.NewContainerWeldIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ProductModificationCode), TABLES.BloodUnitModification.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ToBloodUnitGuid), TABLES.BloodUnitModification.ToBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromOriginalVolume), TABLES.BloodUnitModification.FromOriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromBloodProductGuid), TABLES.BloodUnitModification.FromBloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromUnitExpirationDate), TABLES.BloodUnitModification.FromUnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationCost), TABLES.BloodUnitModification.ModificationCost);
		}

		[Test]
		public void GetEmptyModificationSupplyTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyModificationSupplyTable(true);

			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.BloodUnitModificationGuid), TABLES.ModificationSupply.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.LastUpdateFunctionId), TABLES.ModificationSupply.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.ModificationSupplyGuid), TABLES.ModificationSupply.ModificationSupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.RecordStatusCode), TABLES.ModificationSupply.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.RowVersion), TABLES.ModificationSupply.RowVersion);
		}

		[Test]
		public void GetEmptyModificationSupplyTable_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyModificationSupplyTable(false);

			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.BloodUnitModificationGuid), TABLES.ModificationSupply.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.LastUpdateFunctionId), TABLES.ModificationSupply.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.ModificationSupplyGuid), TABLES.ModificationSupply.ModificationSupplyGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.RecordStatusCode), TABLES.ModificationSupply.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationSupply.SupplyGuid), TABLES.ModificationSupply.SupplyGuid);
			
		}

		
		[Test]
		public void GetEmptyModificationEquipmentTable_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyModificationEquipmentTable(true);

			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.BloodUnitModificationGuid), TABLES.ModificationEquipment.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.LastUpdateFunctionId), TABLES.ModificationEquipment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.ModificationEquipmentGuid), TABLES.ModificationEquipment.ModificationEquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.RecordStatusCode), TABLES.ModificationEquipment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.RowVersion), TABLES.ModificationEquipment.RowVersion);
		}

		[Test]
		public void GetEmptyModificationEquipmentTable_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetEmptyModificationEquipmentTable(false);

			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.BloodUnitModificationGuid), TABLES.ModificationEquipment.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.LastUpdateFunctionId), TABLES.ModificationEquipment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.ModificationEquipmentGuid), TABLES.ModificationEquipment.ModificationEquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.RecordStatusCode), TABLES.ModificationEquipment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ModificationEquipment.EquipmentGuid), TABLES.ModificationEquipment.EquipmentGuid);
		}


		[Test]
		public void GetModifiedBloodUnitChildren_Pass()
		{
			DataRow[] drTemp = this._dtModification.Select("ProductModificationCode = 'S'");
			System.Guid unitGuid = (System.Guid)drTemp[0][TABLES.BloodUnitModification.FromBloodUnitGuid];


			DataTable dtDb = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM BloodUnitModification BUM JOIN vw_BloodShipPatientAllCurrent BU ON BUM.ToBloodUnitGuid = BU.BloodUnitGuid WHERE BUM.ToBloodUnitGuid != '" + unitGuid.ToString() + "' AND BUM.FromBloodUnitGuid = '" + unitGuid.ToString() + "' AND BUM.RecordStatusCode = 'A'");
			DataTable dtTest = DAL.BloodUnitModification.GetModifiedBloodUnitChildren(unitGuid);


			Assert.AreEqual(dtDb.Rows.Count, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(41, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
		}

		[Test]
		public void GetModifiedBloodUnitChildren_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetModifiedBloodUnitChildren(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitModificationsByUnitGuid_Pass()
		{
			Guid fromGuid = (Guid)this._dtModification.Rows[0][TABLES.BloodUnitModification.FromBloodUnitGuid];
			DataTable dtTest = DAL.BloodUnitModification.GetBloodUnitModificationsByUnitGuid(fromGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(21, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.BloodUnitModificationGuid), TABLES.BloodUnitModification.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromBloodUnitGuid), TABLES.BloodUnitModification.FromBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ToBloodUnitGuid), TABLES.BloodUnitModification.ToBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ProductModificationCode), TABLES.BloodUnitModification.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationDate), TABLES.BloodUnitModification.ModificationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationTechId), TABLES.BloodUnitModification.ModificationTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationMethodCode), TABLES.BloodUnitModification.ModificationMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewContainerWeldIndicator), TABLES.BloodUnitModification.NewContainerWeldIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.NewLabelVerificationDatetime), TABLES.BloodUnitModification.NewLabelVerificationDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.DivisionCode), TABLES.BloodUnitModification.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.RecordStatusCode), TABLES.BloodUnitModification.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.LastUpdateDate), TABLES.BloodUnitModification.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.LastUpdateUser), TABLES.BloodUnitModification.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.RowVersion), TABLES.BloodUnitModification.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromOriginalVolume), TABLES.BloodUnitModification.BloodUnitModificationGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromBloodProductGuid), TABLES.BloodUnitModification.FromOriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromUnitExpirationDate), TABLES.BloodUnitModification.FromUnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.FromProductShipperGuid), TABLES.BloodUnitModification.FromProductShipperGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationCost), TABLES.BloodUnitModification.ModificationCost);
		}

		[Test]
		public void GetBloodUnitModificationsByUnitGuid_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetBloodUnitModificationsByUnitGuid(System.Guid.NewGuid());
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}



		[Test]
		public void GetUnitModifications_Pass()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetUnitModifications(_currentDateTime.AddYears(-1), _currentDateTime);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ToBloodUnitGuid), TABLES.BloodUnitModification.ToBloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitModification.ModificationDate), TABLES.BloodUnitModification.ModificationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.ProductModificationText), TABLES.ProductModification.ProductModificationText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModificationParameter.ProductModificationCost), TABLES.ProductModificationParameter.ProductModificationCost);
		}

		[Test]
		public void GetUnitModifications_Fail()
		{
			DataTable dtTest = DAL.BloodUnitModification.GetUnitModifications(_currentDateTime.AddDays(1), _currentDateTime);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetMostRecentBloodUnitShipmentRecordForBloodUnit_Pass()
		{
			DataRow drData = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 BloodUnitGuid FROM dbo.BloodUnitShipment WHERE IncomingShipmentGuid IS NOT NULL");
			System.Guid bug = (System.Guid) drData[TABLES.BloodUnit.BloodUnitGuid];
			//
			DataRow drTest = DAL.BloodUnitModification.GetMostRecentBloodUnitShipmentRecordForBloodUnit(bug);
			//
			Assert.AreEqual(2, drTest.Table.Columns.Count, "Columns.Count");
			//
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.BloodUnitShipment.BloodUnitShipmentGuid), TABLES.BloodUnitShipment.BloodUnitShipmentGuid);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.BloodUnitShipment.RowVersion), TABLES.BloodUnitShipment.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(IndexOutOfRangeException))]
		public void GetMostRecentBloodUnitShipmentRecordForBloodUnit_Fail()
		{
			DAL.BloodUnitModification.GetMostRecentBloodUnitShipmentRecordForBloodUnit(System.Guid.NewGuid());
		}

		
		[Test]
		public void WasBloodUnitPooledOrSplit_Pass()
		{
			DataTable dtTemp = DAL.BloodUnitModification.GetPooledBloodUnits();

			bool retValue = DAL.BloodUnitModification.WasBloodUnitPooledOrSplit((System.Guid)dtTemp.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void WasBloodUnitPooledOrSplit_Fail()
		{
			bool retValue = DAL.BloodUnitModification.WasBloodUnitPooledOrSplit(System.Guid.NewGuid());
			
			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		#region Helper Methods

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private DataRow CheckAndInsertPoolCounterIfNeeded()
		{
			string query = "SELECT TOP 1 * FROM PoolCounter WHERE DivisionCode = '" 
				+ this.TestDivisionCode 
				+ "' AND CounterYear = '" 
				+ System.DateTime.Now.ToString("yy")
				+ "' ORDER BY LastUpdateDate DESC";
			//
			DataRow drCurrent = UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned(query);
			//
			if (drCurrent == null)
			{
				string insertStatement = "INSERT INTO PoolCounter"
					+ "( PoolCounterGuid, CounterValue, CounterYear, DivisionCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId ) "
					+ "VALUES( NEWID(), 1, "
					+ System.DateTime.Now.ToString("yy")
					+ ", "
					+ this.TestDivisionCode
					+ ", 'A', GETUTCDATE(), 'TEST', '00' ) ";
				//
				UnitTestUtil.RunSQL(insertStatement);
				//
				return  UnitTestUtil.RunSQLGetDataRow(query);
			}
			//
			return drCurrent;
		}

		#endregion
	}
}
#endif
